<?php

namespace App\Models\Orgs;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('bonus_limit');

    public function getInstitutionsResponsibleFor()
    {
        return $this->hasMany('Institution', 'responsible_id');
    }

    public function getEventFacts()
    {
        return $this->hasMany('Events');
    }

    public function getChallenges()
    {
        return $this->hasMany('Challenge');
    }

    public function getQuizes()
    {
        return $this->hasMany('Quiz');
    }

    public function getInstitution()
    {
        return $this->belongsTo('Institution');
    }

    public function getActivities()
    {
        return $this->hasMany('Activity');
    }

}